%%% mon2017dev.cls ---      
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{mon2017dev}
  [2021/01/17 v0.07 vakthesis support document class (OMB)]
%  
\RequirePackage{xkeyval}
%  
\define@choicekey{mon2017dev.cls}{type}[\val\nr]{c,d,phd,artd,scd}{%
  \ifcase\nr\relax
    \AtBeginDocument{%
      \addto\captionsenglish{%
        \def\degreename{candidate of}%
        \def\degreephdname{doctor of philosophy}%
      }%
      \addto\captionsukrainian{%
        \def\degreename{\cyrk\cyra\cyrn\cyrd\cyri\cyrd\cyra\cyrt\cyra}%
        \def\degreephdname{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrf\cyrii\cyrl\cyro\cyrs\cyro\cyrf\cyrii\cyryi}%
      }%
    }%
  \or
    \AtBeginDocument{%
      \addto\captionsenglish{\def\degreename{doctor of}}%
      \addto\captionsukrainian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra}}%
    }%
  \or
    \AtBeginDocument{%
      \addto\captionsenglish{\def\degreename{doctor of philosophy}}%
      \addto\captionsukrainian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrf\cyrii\cyrl\cyro\cyrs\cyro\cyrf\cyrii\cyryi}}%
    }%
  \or
    \AtBeginDocument{%
      \addto\captionsenglish{\def\degreename{doctor of arts}}%
      \addto\captionsukrainian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrm\cyri\cyrs\cyrt\cyre\cyrc\cyrt\cyrv\cyra}}%
    }%
  \or
    \AtBeginDocument{%
      \addto\captionsenglish{\def\degreename{doctor of science}}%
      \addto\captionsukrainian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrn\cyra\cyru\cyrk}}%
    }%
  \fi
  \ifnum\nr<2\relax
    \AtEndOfClass{%
      \let\speciality\specialitysci
    }%
    \def\set@degree{\csname set@degree@\val\endcsname}%
    \def\set@speciality{\set@speciality@cd}%
    \def\set@abstract@speciality{\set@abstract@speciality@cd}%
    \PassOptionsToClass{\val}{vakthesis}%
  \else
    \AtEndOfClass{%
      \let\speciality\specialityedu
    }%
    \def\set@degree{\set@degree@phdartdscd}%
    \def\set@speciality{\set@speciality@phdartdscd}%
    \def\set@abstract@speciality{\set@abstract@speciality@phdartdscd}%
  \fi
  \ifnum\nr=4\relax
    \AtBeginDocument{%
      \def\onesupervisorname{\CYRN\cyra\cyru\cyrk\cyro\cyrv\cyri\cyrishrt\
        \cyrk\cyro\cyrn\cyrs\cyru\cyrl\cyrsftsn\cyrt\cyra\cyrn\cyrt}%
      \def\manysupervisorsname{\CYRN\cyra\cyru\cyrk\cyro\cyrv\cyrii\
        \cyrk\cyro\cyrn\cyrs\cyru\cyrl\cyrsftsn\cyrt\cyra\cyrn\cyrt\cyri}%
    }%
  \fi
}
%     
%     ,      
\define@choicekey{mon2017dev.cls}{instnameorder}{desc,asc,ascd}{%
  \def\set@institutions{\csname set@institutions@#1\endcsname}%
}
%   councilsec --     
%     .
%      (   ).
\define@boolkey{mon2017dev.cls}{councilsec}[true]{%
  \ClassWarningNoLine{mon2017dev}{%
    Option `councilsec' is not used in the current\MessageBreak
    version of mon2017dev class%
  }%
}
% ϳ     , 
%      
%  ,    
\DeclareOptionX<mon2017dev.cls>{guide}{%
  \IfFileExists{#1.clo}%
    {\AtEndOfClass{\input{#1.clo}}}%
    {\ClassError{mon2017dev}{You cannot use option `guide=#1'}%
       {File `#1.clo' not found.}}}
%     vakthesis
\DeclareOptionX*{%
  \PassOptionsToClass{\CurrentOption}{vakthesis}%
}
\ExecuteOptionsX{type=c,instnameorder=desc}
\ProcessOptionsX
\LoadClass{vakthesis}[2009/04/01]
\RequirePackage{environ}
%  suffix       (uk), (en) .
\RequirePackage{suffix}
%   uk, en    .
\def\uklanguage{ukrainian}
\def\enlanguage{english}
% TODO:   , ,    ,
%          \frlanguage,
%     :
%   \def\frlanguage{french}
%  ,       <<>>
%   -   .
%   ,      
% TODO:  ,    ,
%          uk, en.
\def\@modifier{@\languagename}
%  datatool     CSV-.
% ³   datatool-base,    amsmath.
%     amsmath (  ),   option clash.
%    datatool .
\AtBeginDocument{%
  \RequirePackage[separator=;]{datatool}%
  % \DTLnewdbonloadfalse
}
%  xstring     .
\usepackage{xstring}
%    .
%    ,
%       .
% \RequirePackage{casus}
\AtBeginDocument{\usepackage{casus}}
% ( )        ,
%   \captions<languagename> ( babel).
%         babel,
%   \@title  .
%     ( \title    ),
%     \captionsenglish  \captionsukrainian.
% ( )  ,    ,  ,
%      (uk), (en)   ,
%         babel  ,
%   \captions<languagename> ( babel)  .
%     ,
%    TODO  .
% TODO: 1.   .
%      䳿 ,
%       
%      .
%    (\author, '  speciality, ...)   ,
%      .
% 2.  ,     babel  ,
%      translations, translator .
% TODO: ,         polyglossia
% ( babel   XeLaTeX  LuaLaTeX),
%      babel.
%     XeLaTeX  LuaLaTeX,
%       .
\renewcommand{\title}[1]{%
  \expandafter\def\csname @title\@modifier\endcsname{#1}%
}
\WithSuffix\def\title(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \title
}
\renewcommand{\author}[1]{%
  \expandafter\def\csname @author\@modifier\endcsname{#1}%
  \expandafter\def\csname @shortauthor\@modifier\endcsname{\@shortifyname#1\@nil}%
  \expandafter\def\csname n@shortauthor\@modifier\endcsname{\n@shortifyname#1\@nil}%
  \expandafter\def\csname e@shortauthor\@modifier\endcsname{\e@shortifyname#1\@nil}%
  \expandafter\def\csname shortauthor@\@modifier\endcsname{\shortifyname@#1\@nil}%
}
\WithSuffix\def\author(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \author
}
%  '   ,   
\def\@shortifyname#1 #2 #3\@nil{%
  \@shortify@name#2\@nil
  \@shortify@name#3\@nil
  #1%
}
% ' ,    ,   
\def\n@shortifyname#1 #2 #3\@nil{%
  #2
  \@shortify@name#3\@nil
  #1%
}
%  ',   ,   
\def\e@shortifyname#1 #2 #3\@nil{%
  \@shortify@name#2\@nil
  #1%
}
\def\@shortify@name#1#2\@nil{#1.~}
%  '   ,   
\def\shortifyname@#1 #2 #3\@nil{%
  #1%
  \shortify@name@#2\@nil
  \shortify@name@#3\@nil
}
\def\shortify@name@#1#2\@nil{~#1.}
%  
%     \supervisor     @supervisors@count.
%    \@supervisors@ukrainian  ,  \supervisor  .
%    --  .
\renewcommand{\supervisor}[3]{%
  \ifcsname @supervisors\@modifier\endcsname
    \expandafter\g@addto@macro\csname @supervisors\@modifier\endcsname{\\{#1}{#2}}%
    \expandafter\def\csname @supervisors@caption\@modifier\endcsname{%
      \manysupervisorsname:%
    }%
  \else
    \expandafter\def\csname @supervisors\@modifier\endcsname{\\{#1}{#2}}%
    \expandafter\def\csname @supervisors@caption\@modifier\endcsname{%
      \onesupervisorname:%
    }%
  \fi
}
\WithSuffix\def\supervisor(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \supervisor
}
%    
%     ,     .
\def\specialityfilename{specsci20150406n394.uk.csv}
%    
\define@key{specialitysci}{specialityname}{%
  \expandafter\def\csname @specialitysci@name\@modifier\endcsname{#1}%
}
\define@key{specialitysci}{degreefield}{%
  \expandafter\def\csname @specialitysci@degreefield\@modifier\endcsname{#1}%
}
\define@key{specialitysci}{specialityfile}{%
  \def\specialityfilename{#1}%
}
\newcommand{\specialitysci}[2][]{%
  \expandafter\def\csname @specialitysci@code\@modifier\endcsname{#2}%
  \setkeys{specialitysci}{#1}%
  \ifthenelse{%
    \expandafter\isundefined
      \expandafter{\csname @specialitysci@name\@modifier\endcsname}
    \or
    \expandafter\isundefined
      \expandafter{\csname @specialitysci@degreefield\@modifier\endcsname}%
  }
  {%
    \DTLloaddb{specdb}{\specialityfilename}%
    \DTLforeach*
    {specdb}
    {\Code=Code,\Name=Name,\Degree=Degree}
    {%
      \DTLifstringeq{\Code}{\csname @specialitysci@code\@modifier\endcsname}
      {%
        \ifcsname @specialitysci@name\@modifier\endcsname
        \else
          \expandafter\edef\csname @specialitysci@name\@modifier\endcsname{\Name}%
        \fi
        \ifcsname @specialitysci@degreefield\@modifier\endcsname
        \else
          \expandafter\edef\csname @specialitysci@degreefield\@modifier\endcsname{\Degree}%
        \fi
        \dtlbreak
      }
      {}%
    }%
    \DTLifdbexists{specdb}{\DTLcleardb{specdb}\DTLdeletedb{specdb}}{}%
  }
  {}%
}
\WithSuffix\def\specialitysci(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \def\specialityfilename{specsci20150406n394.#1.csv}%
  \specialitysci
}
%      ,
%       
\define@key{specialityedu}{specialityname}{%
  \expandafter\def\csname @specialityedu@name\@modifier\endcsname{#1}%
}
\define@key{specialityedu}{fieldcode}{%
  \expandafter\def\csname @specialityedu@fieldcode\@modifier\endcsname{#1}%
}
\define@key{specialityedu}{fieldname}{%
  \expandafter\def\csname @specialityedu@fieldname\@modifier\endcsname{#1}%
}
\define@key{specialityedu}{specialityfile}{%
  \def\specialityfilename{#1}%
}
\newcommand{\specialityedu}[2][]{%
  \expandafter\def\csname @specialityedu@code\@modifier\endcsname{#2}%
  \setkeys{specialityedu}{#1}%
  \ifthenelse{%
    \expandafter\isundefined
      \expandafter{\csname @specialityedu@name\@modifier\endcsname}
    \or
    \expandafter\isundefined
      \expandafter{\csname @specialityedu@fieldname\@modifier\endcsname}%
  }
  {\DTLloaddb{specdb}{\specialityfilename}}
  {}%
  \ifcsname @specialityedu@name\@modifier\endcsname
  \else
    \DTLforeach*
    {specdb}
    {\Code=Code,\Name=Name}
    {%
      \DTLifstringeq{\Code}{\csname @specialityedu@code\@modifier\endcsname}
      {%
        \expandafter\edef\csname @specialityedu@name\@modifier\endcsname{\Name}%
        \dtlbreak
      }
      {}%
    }%
  \fi
  \ifcsname @specialityedu@fieldcode\@modifier\endcsname
  \else
    % \expandafter\def\csname @specialityedu@fieldcode\@modifier\endcsname
    %   {\substr{#2}{1}{2}}%      \DTLforeach*
    \expandafter\def\csname @specialityedu@fieldcode\@modifier\endcsname
      {\@gobble@third@digit#2\@nil}%   :   
  \fi
  \ifcsname @specialityedu@fieldname\@modifier\endcsname
  \else
    \DTLforeach*
    {specdb}
    {\Code=Code,\Name=Name}
    {%
      \DTLifstringeq{\Code}{\csname @specialityedu@fieldcode\@modifier\endcsname}
      {%
        \expandafter\edef\csname @specialityedu@fieldname\@modifier\endcsname{\Name}%
        \dtlbreak
      }
      {}%
    }%
  \fi
  \DTLifdbexists{specdb}{\DTLcleardb{specdb}\DTLdeletedb{specdb}}{}%
}
\def\@gobble@third@digit#1#2#3\@nil{#1#2}
\WithSuffix\def\specialityedu(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \def\specialityfilename{specedu20170201n53.#1.csv}%
  \specialityedu
}
% ,   
\define@key{institution}{altname}{%
  \expandafter\def\csname @institution@altname\@modifier\endcsname{#1}%
}
%  department  preposition --     
%     .
%      (   ).
\define@key{institution}{department}{%
  % \expandafter\def\csname @institution@department\@modifier\endcsname{#1}%
  \ClassWarning{mon2017dev}{%
    Option `department' is not used in the current\MessageBreak
    version of mon2017dev class%
  }%
}
\define@key{institution}{preposition}{%
  % \expandafter\def\csname @institution@preposition\@modifier\endcsname{#1}%
  \ClassWarning{mon2017dev}{%
    Option `preposition' is not used in the current\MessageBreak
    version of mon2017dev class%
  }%
}
\renewcommand{\institution}[3][]{%
  \@split@institution#2,,\@nil
  \setkeys{institution}{#1}%
  \expandafter\def\csname @towni\@modifier\endcsname{#3}%
}
\def\@split@institution#1,#2,#3\@nil{%
  \expandafter\def\csname @institution\@modifier\endcsname{#1}%
  \ifx\relax#2\relax
  \else
    \expandafter\def\csname @institution@office\@modifier\endcsname{\ignorespaces#2}%
  \fi
}
\WithSuffix\def\institution(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \institution
}
% ,   
%%  
%% \council[
%%   institution={, },
%%   altname=  ,
%%   address={ },
%%   town=
%% ]{ }
\define@key{council}{institution}{%
  \@split@council@institution#1,,\@nil
}
\def\@split@council@institution#1,#2,#3\@nil{%
  \expandafter\def\csname @council@institution\@modifier\endcsname{#1}%
  \ifx\relax#2\relax
  \else
    \expandafter\def\csname @council@institution@office\@modifier\endcsname{\ignorespaces#2}%
  \fi
}
\define@key{council}{altname}{%
  \expandafter\def\csname @council@institution@altname\@modifier\endcsname{#1}%
}
%+TODO:      address
% TODO:       ,     .
\define@key{council}{address}{%
  %     (  )
}
\define@key{council}{town}{%
  \expandafter\def\csname @council@town\@modifier\endcsname{#1}%
}
\newcommand{\council}[2][]{%
  \expandafter\def\csname @council@code\@modifier\endcsname{#2}%
  \setkeys{council}{#1}%
}
\WithSuffix\def\council(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \council
}
%  \secretary --     
%     .
%      (   ).
\newcommand{\secretary}[2][]{%
  % \setkeys{secretary}{#1}%
  % \expandafter\def\csname @secretary\@modifier\endcsname{#2}%
  \ClassWarning{mon2017dev}{%
    Command \protect\secretary\space is not used in the current\MessageBreak
    version of mon2017dev class%
  }%
}
\WithSuffix\def\secretary(#1){%
  % \def\@modifier{@\csname#1language\endcsname}%
  \secretary
}
%  
% \facsimilesig#1(#2)[#3]#4 -> \put(#2){\includegraphics[#3]{#4}}
% #1   = author
% (#2) = (  x,   y)
% [#3] = [  \includegraphics]
% #4   = '    
%     .   mon2017dev-aref.cls.
\def\facsimilesig#1(#2)[#3]#4{%
  \expandafter\def\csname #1@signature\endcsname{%
    \put(#2){\includegraphics[#3]{#4}}%
  }%
}
%  \library --     
%     .
%      (   ).
\newcommand{\library}[2]{%
  % \ifx\relax#1\relax
  % \else
  %   \expandafter\def\csname @library@institution\@modifier\endcsname{#1}%
  % \fi
  % \ifx\relax#2\relax
  % \else
  %   \expandafter\def\csname @library@address\@modifier\endcsname{#2}%
  % \fi
  \ClassWarning{mon2017dev}{%
    Command \protect\library\space is not used in the current\MessageBreak
    version of mon2017dev class%
  }%
}
\WithSuffix\def\library(#1){%
  % \def\@modifier{@\csname#1language\endcsname}%
  \library
}
%         .
%    ,   .
% (  vakaref.cls  )
\newenvironment{listofpersons}[1]
  {\list{#1\hfil}{\topsep0pt\parsep0pt\itemsep.5\parskip
   \settowidth\@tempdima{#1}%
   \setlength\labelwidth{\@tempdima}%
   \setlength\leftmargin{\labelwidth}%
   \addtolength\leftmargin{\labelsep}%
   \def\makelabel##1{##1}%
   \def\makephantomlabel##1{\phantom{##1}}}%
   \rightskip\@flushglue% !   ,      
                        % ?   Underfull \hbox
  }
  {\endlist}
%  
\renewcommand\maketitle{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \let \footnote \thanks
  \@maketitle
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  % \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
%         
%    
\def\set@institutions@desc{%
  {\scshape
   \ifcsname @institution@office@\languagename\endcsname
     \csname @institution@office@\languagename\endcsname\par
   \fi
   \csname @institution@\languagename\endcsname\par}
  \smallskip
  {\scshape
   \ifcsname @council@institution@office@\languagename\endcsname
     \csname @council@institution@office@\languagename\endcsname\par
   \fi
   \csname @council@institution@\languagename\endcsname\par}
}
\def\set@institutions@asc{%
  {\scshape
   \csname @institution@\languagename\endcsname\par
   \ifcsname @institution@office@\languagename\endcsname
     \csname @institution@office@\languagename\endcsname\par
   \fi}
  \smallskip
  {\scshape
   \csname @council@institution@\languagename\endcsname\par
   \ifcsname @council@institution@office@\languagename\endcsname
     \csname @council@institution@office@\languagename\endcsname\par
   \fi}
}
% REVIEW:   
% \@institution@office@ukrainian  \@council@institutiont@office@ukrainian,
%    .
% ,         .
%    ,       ,
%     -- .
\def\set@institutions@ascd{%
  {\scshape
   \csname @institution@\languagename\endcsname\par
   \ifcsname @institution@office@\languagename\endcsname
     \iflanguage{ukrainian}%
       {\transformsentence{G}{\@institution@office@ukrainian} }%
       {\csname @institution@office@\languagename\endcsname}%
     \par
   \fi}
  \smallskip
  {\scshape
   \csname @council@institution@\languagename\endcsname\par
   \ifcsname @council@institution@office@\languagename\endcsname
     \iflanguage{ukrainian}%
       {\transformsentence{G}{\@council@institution@office@ukrainian} }%
       {\csname @council@institution@office@\languagename\endcsname}%
     \par
   \fi}
}
%       
%    
% (     )
%    2019/10/01   ,
%        
%         ,
%     c     
%  ...  ( )
%           :
%   .
%         ,
%      ,
%    : \specialitysci  \specialityedu.
\def\set@speciality@cd{%
  \csname @specialitysci@code@\languagename\endcsname\
  \cdash---
  \csname @specialitysci@name@\languagename\endcsname
  \ifcsname @specialityedu@code@\languagename\endcsname
    \par
    \csname @specialityedu@code@\languagename\endcsname\
    \cdash---
    \csname @specialityedu@name@\languagename\endcsname
  \fi
}
\def\set@abstract@speciality@cd{%
  \csname @specialitysci@code@\languagename\endcsname\
  \cdash---
  \csname @specialitysci@name@\languagename\endcsname
  \ifcsname @specialityedu@code@\languagename\endcsname
    \ (\csname @specialityedu@code@\languagename\endcsname\
    \cdash---
    \csname @specialityedu@name@\languagename\endcsname)%
  \fi
}
\def\set@speciality@phdartdscd{%
  \csname @specialityedu@code@\languagename\endcsname\
  \cdash---
  \csname @specialityedu@name@\languagename\endcsname\par
  \csname @specialityedu@fieldname@\languagename\endcsname
}
\def\set@abstract@speciality@phdartdscd{%
  \csname @specialityedu@code@\languagename\endcsname\
  \cdash---
  \csname @specialityedu@name@\languagename\endcsname
}
%  mon2017dev.karazin.clo  degreefield   ,    .
%    CSV-:     ,
%       .
%   ,    , :
% https://uk.wikipedia.org/wiki/_#_
% https://uk.wikipedia.org/wiki/_#____
\def\degreefield@tf@ukrainian#1{%
  \IfEndWith{#1}{\cyrii}{%
    \StrGobbleRight{#1}{1}\cyri\cyrh\ \cyrn\cyra\cyru\cyrk
    % \case[adjective]{G}{#1} %   
  }{%
    \IfStrEqCase{#1}{%
      {\cyra\cyrr\cyrh\cyrii\cyrt\cyre\cyrk\cyrt\cyru\cyrr\cyra}% 
      {\StrGobbleRight{#1}{1}\cyri}% \case{G}{#1}   
      {\cyrk\cyru\cyrl\cyrsftsn\cyrt\cyru\cyrr\cyro\cyrl\cyro\cyrg\cyrii\cyrya}% 
      {\StrGobbleRight{#1}{1}\cyryi}%
      {\cyrm\cyri\cyrs\cyrt\cyre\cyrc\cyrt\cyrv\cyro\cyrz\cyrn\cyra\cyrv\cyrs\cyrt\cyrv\cyro}% 
      {\StrGobbleRight{#1}{1}\cyra}%
      {\cyrd\cyre\cyrr\cyrzh\cyra\cyrv\cyrn\cyre\space
        \cyru\cyrp\cyrr\cyra\cyrv\cyrl\cyrii\cyrn\cyrn\cyrya}%  
      {\cyrn\cyra\cyru\cyrk\ \cyrz\
        \cyrd\cyre\cyrr\cyrzh\cyra\cyrv\cyrn\cyro\cyrg\cyro\
        \cyru\cyrp\cyrr\cyra\cyrv\cyrl\cyrii\cyrn\cyrn\cyrya}%
      {\cyrf\cyrii\cyrz\cyri\cyrch\cyrn\cyre\space
        \cyrv\cyri\cyrh\cyro\cyrv\cyra\cyrn\cyrn\cyrya\space
        \cyrii\space
        \cyrs\cyrp\cyro\cyrr\cyrt}%    
      {\cyrn\cyra\cyru\cyrk\ \cyrz\
        \cyrf\cyrii\cyrz\cyri\cyrch\cyrn\cyro\cyrg\cyro\
        \cyrv\cyri\cyrh\cyro\cyrv\cyra\cyrn\cyrn\cyrya\
        \cyrii\
        \cyrs\cyrp\cyro\cyrr\cyrt\cyru}%
      {\cyrs\cyro\cyrc\cyrii\cyra\cyrl\cyrsftsn\cyrn\cyrii\space
        \cyrk\cyro\cyrm\cyru\cyrn\cyrii\cyrk\cyra\cyrc\cyrii\cyryi}%  
      {\cyrn\cyra\cyru\cyrk\ \cyrii\cyrz\
        \cyrs\cyro\cyrc\cyrii\cyra\cyrl\cyrsftsn\cyrn\cyri\cyrh\
        \cyrk\cyro\cyrm\cyru\cyrn\cyrii\cyrk\cyra\cyrc\cyrii\cyrishrt}%
    }%
    [#1]%
  }%
}
% TODO:       ( ).
%          .
%      (  ).
\def\degreefield@tf@english#1{#1 sciences}
\def\set@degree@c{%
  \degreename\
  \csname degreefield@tf@\languagename\endcsname{\csname @specialitysci@degreefield@\languagename\endcsname}%
  \ifcsname @specialityedu@code@\languagename\endcsname
    \ (\degreephdname)%
  \fi
}
%   ,       0.04,
%     \set@degree    c  d.
%  \degreename\  \csname   ,
%       
%          d.
%    2020/07/28   .
\def\set@degree@d{%
  \degreename\
  \csname degreefield@tf@\languagename\endcsname{\csname @specialitysci@degreefield@\languagename\endcsname}%
}
\def\set@degree@phdartdscd{%
  \degreename
}
\def\@maketitle{%
  \set@institutions
  \vspace{\stretch{3}}%
  {\raggedleft
    \parbox[b]{165pt}{\raggedright\manuscriptname}%
    \par}%
  \vspace{\stretch{2}}%
  {\bfseries\expandafter\expandafter\expandafter\emphsurname\csname @author@\languagename\endcsname \par}%
  \vspace{\stretch{2}}%
  {\raggedleft
    \@ifundefined{@secret}{}{%
      \@secret\\
      \CYRP\cyrr\cyri\cyrm.~\No~\placeholder[5mm]\\}
    \CYRU\CYRD\CYRK\ \@udc \par}%
  \vspace{\stretch{1}}%
  {\bfseries\scshape\CYRD\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyrya\par}
  {\large\bfseries\scshape \csname @title@\languagename\endcsname \par}%
  \vspace{\stretch{1}}%
  \set@speciality\par
  \vspace{\stretch{1}}%
  %     
  \CYRP\cyro\cyrd\cyra\cyrie\cyrt\cyrsftsn\cyrs\cyrya\
  \cyrn\cyra\ \cyrz\cyrd\cyro\cyrb\cyru\cyrt\cyrt\cyrya\
  \cyrn\cyra\cyru\cyrk\cyro\cyrv\cyro\cyrg\cyro\
  \cyrs\cyrt\cyru\cyrp\cyre\cyrn\cyrya\\
  \set@degree\par
  \end{center}
  \vspace{\stretch{2}}%
  {\small%       ,  .
    %     .
    \CYRD\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyrya\
    \cyrm\cyrii\cyrs\cyrt\cyri\cyrt\cyrsftsn\
    \cyrr\cyre\cyrz\cyru\cyrl\cyrsftsn\cyrt\cyra\cyrt\cyri\
    \cyrv\cyrl\cyra\cyrs\cyrn\cyri\cyrh\
    \cyrd\cyro\cyrs\cyrl\cyrii\cyrd\cyrzh\cyre\cyrn\cyrsftsn.
    %  ,          
    \CYRV\cyri\cyrk\cyro\cyrr\cyri\cyrs\cyrt\cyra\cyrn\cyrn\cyrya\
    \cyrii\cyrd\cyre\cyrishrt,
    \cyrr\cyre\cyrz\cyru\cyrl\cyrsftsn\cyrt\cyra\cyrt\cyrii\cyrv\
    \cyrii~%
    \cyrt\cyre\cyrk\cyrs\cyrt\cyrii\cyrv\
    \cyrii\cyrn\cyrsh\cyri\cyrh\
    \cyra\cyrv\cyrt\cyro\cyrr\cyrii\cyrv\
    \cyrm\cyra\cyryu\cyrt\cyrsftsn\
    \cyrp\cyro\cyrs\cyri\cyrl\cyra\cyrn\cyrn\cyrya\
    \cyrn\cyra\
    \cyrv\cyrii\cyrd\cyrp\cyro\cyrv\cyrii\cyrd\cyrn\cyre\
    \cyrd\cyrzh\cyre\cyrr\cyre\cyrl\cyro.\par
    \medskip
    \raggedleft
    \ifcsname author@signature\endcsname
      \begin{picture}(0,0)
        \csname author@signature\endcsname
      \end{picture}
    \else
      \placeholder[25mm]
    \fi
    \csname @shortauthor@\languagename\endcsname\par}
  \vspace{\stretch{2}}%
  {%
   \let\\\@format@person
   \ifcsname @supervisors@\languagename\endcsname
     \begin{listofpersons}{\csname @supervisors@caption@\languagename\endcsname}
       \csname @supervisors@\languagename\endcsname\relax
     \end{listofpersons}
   \fi
  }%
  \vspace{\stretch{3}}%
  \begin{center}
  \csname @towni@\languagename\endcsname\ --- \@year}
\def\@format@person#1#2{\item
  \textbf{#1}, \linebreak[1]\@@format@person#2,,\@nil
  \let\makelabel\makephantomlabel
  \futurelet\next\@delimit@person}
% Abstract    ,     
\define@cmdkey{abstract}{language}{}
\define@cmdkey{abstract}{chapter}{}
\define@boolkey{abstract}{header}[true]{}
\renewenvironment{abstract}[1][]{%
  \KV@abstract@headertrue
  \setkeys{abstract}{#1}%
  \ifdefined\cmdKV@abstract@language
    \expandafter\selectlanguage\expandafter{\cmdKV@abstract@language}%
  \fi
  \ifdefined\cmdKV@abstract@chapter
    \def\@tempa{true}%
    \def\@tempb{false}%
    \ifx\cmdKV@abstract@chapter\@tempb
      \bigskip
    \else
      \ifx\cmdKV@abstract@chapter\@tempa
      \else
        \def\abstractname{\cmdKV@abstract@chapter}%
      \fi
      % \chapter*{\abstractname}%
      %       .
      % REVIEW:   \tableofcontents.
      %   .
      \@tocheader{%
        \abstractname
        \@mkboth{\MakeUppercase\abstractname}{\MakeUppercase\abstractname}%
      }%
    \fi
  \else
    % \chapter*{\abstractname}%
    %       .
    % REVIEW:   \tableofcontents.
    %   .
    \@tocheader{%
      \abstractname
      \@mkboth{\MakeUppercase\abstractname}{\MakeUppercase\abstractname}%
    }%
  \fi
  \ifKV@abstract@header
    \@abstract
  \fi
}{%
}
\def\@abstract{%
  \emph{\csname shortauthor@@\languagename\endcsname}
  \csname @title@\languagename\endcsname.
  \cdash---
  \manuscriptname.
  \par
  \set@thesisdescription.
  \cdash---
  \ifcsname @institution@altname@\languagename\endcsname
    \csname @institution@altname@\languagename\endcsname
  \else
    \ifcsname @institution@office@\languagename\endcsname
      \csname @institution@office@\languagename\endcsname,
    \fi
    \csname @institution@\languagename\endcsname
  \fi
  \ifcsname @council@town@\languagename\endcsname
    \ifthenelse{\equal{\csname @towni@\languagename\endcsname}{\csname @council@town@\languagename\endcsname}}%
      {}%
      {, \csname @towni@\languagename\endcsname}%
  \fi
  \ifcsname @council@institution@altname@\languagename\endcsname
    ; \csname @council@institution@altname@\languagename\endcsname
  \else
    \ifcsname @council@institution@\languagename\endcsname
      ;
      \ifcsname @council@institution@office@\languagename\endcsname
        \csname @council@institution@office@\languagename\endcsname,
      \fi
      \csname @council@institution@\languagename\endcsname
    \fi
  \fi
  ,
  \ifcsname @council@town@\languagename\endcsname
    \csname @council@town@\languagename\endcsname
  \else
    \csname @towni@\languagename\endcsname
  \fi,
  \@year.
  \par
  \smallskip
}
%       (   ,   )
\newcommand{\keywords}[1]{%
  \smallskip
  \emph{\keywordsname}:
  #1.
  \par
  % \bigskip
}
%        .
% TODO:   approval  ?
% https://en.wiktionary.org/wiki/approval
% https://en.wiktionary.org/wiki/approbation
% https://e2u.org.ua/s?w=%D0%B0%D0%BF%D1%80%D0%BE%D0%B1%D0%B0%D1%86%D1%96%D1%8F&dicts=all&highlight=on&filter_lines=on
\NewEnviron{approval}[1][\approvalname]{%
  \paragraph{#1}%
  \global\let\sav@approval\BODY
  \BODY
}
\newcommand{\repeatapproval}{%
  \def\approvalname{%
    % ³    
    {\cyr\CYRV\cyrii\cyrd\cyro\cyrm\cyro\cyrs\cyrt\cyrii\
      \cyrp\cyrr\cyro\
      \cyra\cyrp\cyrr\cyro\cyrb\cyra\cyrc\cyrii\cyryu\
      \cyrr\cyre\cyrz\cyru\cyrl\cyrsftsn\cyrt\cyra\cyrt\cyrii\cyrv\
      \cyrd\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyryi}%
  }%
  \renewcommand{\participation}[1]{\unskip, ##1}%
  \section{\approvalname}%
  \sav@approval
}
\def\approvalname{%
  %   
  {\cyr\CYRA\cyrp\cyrr\cyro\cyrb\cyra\cyrc\cyrii\cyrya\
    \cyrm\cyra\cyrt\cyre\cyrr\cyrii\cyra\cyrl\cyrii\cyrv\
    \cyrd\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyryi}%
}%
% ֳ      .
%    ,     ,    -- .
\newcommand{\participation}[1]{\unskip}
%   
%    ,  ,     
\newenvironment{authorpublications}[1]
     {% \chapter*{\bibname}%
      % \@mkboth{\MakeUppercase\bibname}{\MakeUppercase\bibname}%
      \@tocheader{%
        \bibname
        \@mkboth{\MakeUppercase\bibname}{\MakeUppercase\bibname}%
      }%
      \list{\@biblabel{\@arabic\c@enumiv\@bibmark}}%
           {\settowidth\labelwidth{\@biblabel{#1\@bibmark}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv\@bibmark}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
     }
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
%    ,  
\newenvironment{reauthorpublications}[1]
     {\section{\bibname}%
      % \@mkboth{\MakeUppercase\bibname}{\MakeUppercase\bibname}%
      \list{\@biblabel{\@arabic\c@enumiv\@bibmark}}%
           {\settowidth\labelwidth{\@biblabel{#1\@bibmark}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv\@bibmark}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
     }
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
%    .
%  ,    ,  \list, \endlist.
% ,      .
%      ,   .
%       .bbl- (  ).
% TODO:  ,   .bbl-   .tex-?
%             ,  BibTeX?
%           .
% TODO:        (.  .),
%           ?
\newcommand{\repeatauthorpublications}{%
  \def\bibname{%      
    {\cyr\CYRS\cyrp\cyri\cyrs\cyro\cyrk\
      \cyrp\cyru\cyrb\cyrl\cyrii\cyrk\cyra\cyrc\cyrii\cyrishrt\
      \cyrz\cyrd\cyro\cyrb\cyru\cyrv\cyra\cyrch\cyra\
      \cyrz\cyra\
      \cyrt\cyre\cyrm\cyro\cyryu\
      \cyrd\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyryi}}%
  \let\thebibliography\reauthorpublications
  \let\endthebibliography\endreauthorpublications
  \let\@lbibitem\simple@lbibitem
  \let\@bibitem\simple@bibitem
  \@input@{\jobname1.bbl}%
}
%  \bibitem,   ,      .
%   multiply-defined labels.
\def\simple@lbibitem[#1]#2{\item[\@biblabel{#1}\hfill]\ignorespaces}
\def\simple@bibitem#1{\item\ignorespaces}
%      authorpublications.
\renewenvironment{bibset}[2][]
  {\stepcounter{currbibset}%
   \def\@temp{#1}%
   \ifx\@temp\@empty
     \def\@bibmark{\relax}%FIXME: \def\@bibmark{}  
   \else
     \def\@bibmark{\textsuperscript{#1}}%
   \fi
   \let\@sav@lbibitem\@lbibitem
   \def\@lbibitem[##1]##2{\@sav@lbibitem[##1\@bibmark]{##2}}%
   \@ifundefined{hyper@warn}
%%     hyperref
     {\def\@bibitem##1{\item\if@filesw \immediate\write\@auxout
        {\string\bibcite{##1}{\the\value{\@listctr}\expandafter\string\@bibmark}}%
        \fi\ignorespaces}}
%%    hyperref
     {\def\@bibitem##1{%
      \@skiphyperreftrue\H@item\@skiphyperreffalse
      \hyper@anchorstart{cite.##1}\relax\hyper@anchorend
      \if@filesw {\let\protect\noexpand
      \immediate\write\@auxout{%
        \string\bibcite{##1}{\the\value{\@listctr}\expandafter\string\@bibmark}}}%
      \fi
      \ignorespaces}}%
   \def\bibname{#2}%
   \let\bibliography\@thisbibliography
   \let\bibliographystyle\@thisbibliographystyle
%  ,       .
   \ifnum\thecurrbibset=1
     \let\thebibliography\authorpublications
     \let\endthebibliography\endauthorpublications
     \let\@lbibitem\simple@lbibitem
     \let\@bibitem\simple@bibitem
   \fi}
  {\ifnum\thecurrbibset=\theneedbibset
     \ifnum\theneedbibset=1
       \immediate\write\@auxout{\string\setcounter{needbibset}{2}}%
     \else
       \immediate\write\@auxout{\string\setcounter{needbibset}{1}}%
     \fi
   \fi}
%   (  )
% TODO:     .
%    ,    .
%   ,     -- ukrainian,
%     .
%       
% ( english --   ).
\AtBeginDocument{%
\addto\captionsenglish{%
  \def\manuscriptname{%
    % FIXME: Qualification  Qualifying?
    Qualification scientific work in the form of manuscript%
  }%
  \def\set@thesisdescription{%
    Thesis for \set@degree\ degree
    in speciality \set@abstract@speciality
  }%
  \def\keywordsname{Key words}%
}
\addto\captionsukrainian{%
  \def\manuscriptname{%
    %      
    \CYRK\cyrv\cyra\cyrl\cyrii\cyrf\cyrii\cyrk\cyra\cyrc\cyrii\cyrishrt\cyrn\cyra\
    \cyrn\cyra\cyru\cyrk\cyro\cyrv\cyra\
    \cyrp\cyrr\cyra\cyrc\cyrya\
    \cyrn\cyra\
    \cyrp\cyrr\cyra\cyrv\cyra\cyrh\
    \cyrr\cyru\cyrk\cyro\cyrp\cyri\cyrs\cyru
  }%
  \def\set@thesisdescription{%
    %     
    %    ( )
    \CYRD\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyrya\
    \cyrn\cyra\
    \cyrz\cyrd\cyro\cyrb\cyru\cyrt\cyrt\cyrya\
    \cyrn\cyra\cyru\cyrk\cyro\cyrv\cyro\cyrg\cyro\
    \cyrs\cyrt\cyru\cyrp\cyre\cyrn\cyrya\
    \set@degree\
    \cyrz\cyra\
    \cyrs\cyrp\cyre\cyrc\cyrii\cyra\cyrl\cyrsftsn\cyrn\cyrii\cyrs\cyrt\cyryu\
    \set@abstract@speciality
  }%
  \def\keywordsname{\CYRK\cyrl\cyryu\cyrch\cyro\cyrv\cyrii\ \cyrs\cyrl\cyro\cyrv\cyra}%
}
}
%
%   babel-ukrainian
%
%   (2018/05/17)    (2019/08/01)  
%  ,    ( \cdash---)   .
%      \makeabstract
% (   0.02  mon2017dev  )
%      :
%   command \cyrdash unavailable in encoding OT1.
%  \cyrdash "---   ,   \cdash.
%      :
\ProvideTextCommandDefault{\cyrdash}{\hbox to.8em{--\hss--}}
%    ,
%   babel-ukrainian  1.4b  2017/08/10
%    .
%    , 
%  \cyrdash        T2A,
%     .
% ,     "--- ,
%  -     \cyrdash  
% (.  babel-ukrainian  1.4b  , ~6.4.2, .~10).
%  ,     
%   ,       babel-ukrainian
% ( 1.1l  2008/03/21),
%  ,     '  .
%    ,  ' ,    .
%     ,       .
%  ,  '  ,
%      \cyrdash.
%
%   vakthesis
%
%    2018/04/15   
% (https://linux.org.ua/index.php?topic=689.msg201933#msg201933),
%    ( enumerate)  
%      \@asbuk.
%    \@Asbuk.
%   vakthesis    \@Asbuk  \@asbuk.
%      babel.
%   babel-ukrainian,    1.4  2017/06/10,
%     .
%    \@Alph  \@alph    .
%  .
\def\@Asbuk{\@Alph}
\def\@asbuk{\@alph}
%       babel-ukrainian,
%     \@Asbuk  \@asbuk,
%    ,  \@Alph  \@alph .
%     babel-ukrainian,
%    \@Asbuk  \@asbuk,
%  babel-ukrainian    ,
%   ,   .
%     \providecommand,
%      (.  BUGS,   2018/04/15),
%     \@Asbuk  \@asbuk  -  .
\endinput
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Local Variables:
% mode: latex
% coding: windows-1251-dos
% End:
