%%% mon2017dev-aref.cls ---       
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{mon2017dev-aref}
  [2021/01/17 v0.03 vakaref support document class (OMB)]
%  
\RequirePackage{xkeyval}
%  
\define@choicekey{mon2017dev-aref.cls}{type}[\val\nr]{c,d,phd,artd,scd}{%
  \ifcase\nr\relax
    \AtBeginDocument{%
      \addto\captionsenglish{%
        \def\degreename{candidate of}%
        \def\degreephdname{doctor of philosophy}%
      }%
      \addto\captionsrussian{%
        \def\degreename{\cyrk\cyra\cyrn\cyrd\cyri\cyrd\cyra\cyrt\cyra}%
        \def\degreephdname{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrf\cyri\cyrl\cyro\cyrs\cyro\cyrf\cyri\cyri}%
      }%
      \addto\captionsukrainian{%
        \def\degreename{\cyrk\cyra\cyrn\cyrd\cyri\cyrd\cyra\cyrt\cyra}%
        \def\degreephdname{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrf\cyrii\cyrl\cyro\cyrs\cyro\cyrf\cyrii\cyryi}%
      }%
    }%
  \or
    \AtBeginDocument{%
      \addto\captionsenglish{\def\degreename{doctor of}}%
      \addto\captionsrussian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra}}%
      \addto\captionsukrainian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra}}%
    }%
  \or
    \AtBeginDocument{%
      \addto\captionsenglish{\def\degreename{doctor of philosophy}}%
      \addto\captionsrussian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrf\cyri\cyrl\cyro\cyrs\cyro\cyrf\cyri\cyri}}%
      \addto\captionsukrainian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrf\cyrii\cyrl\cyro\cyrs\cyro\cyrf\cyrii\cyryi}}%
    }%
  \or
    \AtBeginDocument{%
      \addto\captionsenglish{\def\degreename{doctor of arts}}%
      \addto\captionsrussian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyri\cyrs\cyrk\cyru\cyrs\cyrs\cyrt\cyrv\cyra}}%
      \addto\captionsukrainian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrm\cyri\cyrs\cyrt\cyre\cyrc\cyrt\cyrv\cyra}}%
    }%
  \or
    \AtBeginDocument{%
      \addto\captionsenglish{\def\degreename{doctor of science}}%
      \addto\captionsrussian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrn\cyra\cyru\cyrk}}%
      \addto\captionsukrainian{\def\degreename{\cyrd\cyro\cyrk\cyrt\cyro\cyrr\cyra\ \cyrn\cyra\cyru\cyrk}}%
    }%
  \fi
  \ifnum\nr<2\relax
    \AtEndOfClass{%
      \let\speciality\specialitysci
    }%
    \def\set@degree{\csname set@degree@\val\endcsname}%
    \def\set@speciality{\set@speciality@cd}%
    \def\set@abstract@speciality{\set@abstract@speciality@cd}%
    \PassOptionsToClass{\val}{vakaref}%
  \else
    \AtEndOfClass{%
      \let\speciality\specialityedu
    }%
    \def\set@degree{\set@degree@phdartdscd}%
    \def\set@speciality{\set@speciality@phdartdscd}%
    \def\set@abstract@speciality{\set@abstract@speciality@phdartdscd}%
  \fi
  \ifnum\nr=4\relax
    \AtBeginDocument{%
      \def\onesupervisorname{\CYRN\cyra\cyru\cyrk\cyro\cyrv\cyri\cyrishrt\
        \cyrk\cyro\cyrn\cyrs\cyru\cyrl\cyrsftsn\cyrt\cyra\cyrn\cyrt}%
      \def\manysupervisorsname{\CYRN\cyra\cyru\cyrk\cyro\cyrv\cyrii\
        \cyrk\cyro\cyrn\cyrs\cyru\cyrl\cyrsftsn\cyrt\cyra\cyrn\cyrt\cyri}%
    }%
  \fi
}
%     
%     ,      
\define@choicekey{mon2017dev-aref.cls}{instnameorder}{desc,asc,ascd}{%
  \def\set@institutions{\csname set@institutions@#1\endcsname}%
}
%          
% TODO:     ?   ,    .
% councilsec =       (COUNCIL code in the SECretary line)
\define@boolkey{mon2017dev-aref.cls}{councilsec}[true]{}
% ϳ     , 
%      
%  ,    
\DeclareOptionX<mon2017dev-aref.cls>{guide}{%
  \IfFileExists{#1.clo}%
    {\AtEndOfClass{\input{#1.clo}}}%
    {\ClassError{mon2017dev-aref}{You cannot use option `guide=#1'}%
       {File `#1.clo' not found.}}}
%     vakaref
\DeclareOptionX*{%
  \PassOptionsToClass{\CurrentOption}{vakaref}%
}
\ExecuteOptionsX{type=c,instnameorder=desc}
\ProcessOptionsX
\LoadClass{vakaref}[2009/04/01]
\RequirePackage{environ}
%  suffix       (uk), (en) .
\RequirePackage{suffix}
%   uk, en    .
\def\uklanguage{ukrainian}
\def\enlanguage{english}
\def\rulanguage{russian}
% TODO:   , ,    ,
%          \frlanguage,
%     :
%   \def\frlanguage{french}
%  ,       <<>>
%   -   .
%   ,      
% TODO:  ,    ,
%          uk, en.
\def\@modifier{@\languagename}
%  datatool     CSV-.
% ³   datatool-base,    amsmath.
%     amsmath (  ),   option clash.
%    datatool .
\AtBeginDocument{%
  \RequirePackage[separator=;]{datatool}%
  % \DTLnewdbonloadfalse
}
%  xstring     .
\usepackage{xstring}
%    .
%    ,
%       .
%    ,     vakaref.
% \RequirePackage{casus}
% \AtBeginDocument{\usepackage{casus}}
% ( )        ,
%   \captions<languagename> ( babel).
%         babel,
%   \@title  .
%     ( \title    ),
%     \captionsenglish  \captionsukrainian.
% ( )  ,    ,  ,
%      (uk), (en)   ,
%         babel  ,
%   \captions<languagename> ( babel)  .
%     ,
%    TODO  .
% TODO: 1.   .
%      䳿 ,
%       
%      .
%    (\author, '  speciality, ...)   ,
%      .
% 2.  ,     babel  ,
%      translations, translator .
% TODO: ,         polyglossia
% ( babel   XeLaTeX  LuaLaTeX),
%      babel.
%     XeLaTeX  LuaLaTeX,
%       .
\renewcommand{\title}[1]{%
  \expandafter\def\csname @title\@modifier\endcsname{#1}%
}
\WithSuffix\def\title(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \title
}
\renewcommand{\author}[1]{%
  \expandafter\def\csname @author\@modifier\endcsname{#1}%
  \expandafter\def\csname @shortauthor\@modifier\endcsname{\@shortifyname#1\@nil}%
  \expandafter\def\csname n@shortauthor\@modifier\endcsname{\n@shortifyname#1\@nil}%
  \expandafter\def\csname e@shortauthor\@modifier\endcsname{\e@shortifyname#1\@nil}%
  \expandafter\def\csname shortauthor@\@modifier\endcsname{\shortifyname@#1\@nil}%
}
\WithSuffix\def\author(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \author
}
%  '   ,   
\def\@shortifyname#1 #2 #3\@nil{%
  \@shortify@name#2\@nil
  \@shortify@name#3\@nil
  #1%
}
% ' ,    ,   
\def\n@shortifyname#1 #2 #3\@nil{%
  #2
  \@shortify@name#3\@nil
  #1%
}
%  ',   ,   
\def\e@shortifyname#1 #2 #3\@nil{%
  \@shortify@name#2\@nil
  #1%
}
\def\@shortify@name#1#2\@nil{#1.~}
%  '   ,   
\def\shortifyname@#1 #2 #3\@nil{%
  #1%
  \shortify@name@#2\@nil
  \shortify@name@#3\@nil
}
\def\shortify@name@#1#2\@nil{~#1.}
%  
%     \supervisor     @supervisors@count.
%    \@supervisors@ukrainian  ,  \supervisor  .
%    --  .
\renewcommand{\supervisor}[3]{%
  \ifcsname @supervisors\@modifier\endcsname
    \expandafter\g@addto@macro\csname @supervisors\@modifier\endcsname{\\{#1}{#2}{#3}}%
    \expandafter\def\csname @supervisors@caption\@modifier\endcsname{%
      \manysupervisorsname:%
    }%
  \else
    \expandafter\def\csname @supervisors\@modifier\endcsname{\\{#1}{#2}{#3}}%
    \expandafter\def\csname @supervisors@caption\@modifier\endcsname{%
      \onesupervisorname:%
    }%
  \fi
}
\WithSuffix\def\supervisor(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \supervisor
}
%    
%     ,     .
\def\specialityfilename{specsci20150406n394.uk.csv}
%    
\define@key{specialitysci}{specialityname}{%
  \expandafter\def\csname @specialitysci@name\@modifier\endcsname{#1}%
}
\define@key{specialitysci}{degreefield}{%
  \expandafter\def\csname @specialitysci@degreefield\@modifier\endcsname{#1}%
}
\define@key{specialitysci}{specialityfile}{%
  \def\specialityfilename{#1}%
}
\newcommand{\specialitysci}[2][]{%
  \expandafter\def\csname @specialitysci@code\@modifier\endcsname{#2}%
  \setkeys{specialitysci}{#1}%
  \ifthenelse{%
    \expandafter\isundefined
      \expandafter{\csname @specialitysci@name\@modifier\endcsname}
    \or
    \expandafter\isundefined
      \expandafter{\csname @specialitysci@degreefield\@modifier\endcsname}%
  }
  {%
    \DTLloaddb{specdb}{\specialityfilename}%
    \DTLforeach*
    {specdb}
    {\Code=Code,\Name=Name,\Degree=Degree}
    {%
      \DTLifstringeq{\Code}{\csname @specialitysci@code\@modifier\endcsname}
      {%
        \ifcsname @specialitysci@name\@modifier\endcsname
        \else
          \expandafter\edef\csname @specialitysci@name\@modifier\endcsname{\Name}%
        \fi
        \ifcsname @specialitysci@degreefield\@modifier\endcsname
        \else
          \expandafter\edef\csname @specialitysci@degreefield\@modifier\endcsname{\Degree}%
        \fi
        \dtlbreak
      }
      {}%
    }%
    \DTLifdbexists{specdb}{\DTLcleardb{specdb}\DTLdeletedb{specdb}}{}%
  }
  {}%
}
\WithSuffix\def\specialitysci(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \def\specialityfilename{specsci20150406n394.#1.csv}%
  \specialitysci
}
%      ,
%       
\define@key{specialityedu}{specialityname}{%
  \expandafter\def\csname @specialityedu@name\@modifier\endcsname{#1}%
}
\define@key{specialityedu}{fieldcode}{%
  \expandafter\def\csname @specialityedu@fieldcode\@modifier\endcsname{#1}%
}
\define@key{specialityedu}{fieldname}{%
  \expandafter\def\csname @specialityedu@fieldname\@modifier\endcsname{#1}%
}
\define@key{specialityedu}{specialityfile}{%
  \def\specialityfilename{#1}%
}
\newcommand{\specialityedu}[2][]{%
  \expandafter\def\csname @specialityedu@code\@modifier\endcsname{#2}%
  \setkeys{specialityedu}{#1}%
  \ifthenelse{%
    \expandafter\isundefined
      \expandafter{\csname @specialityedu@name\@modifier\endcsname}
    \or
    \expandafter\isundefined
      \expandafter{\csname @specialityedu@fieldname\@modifier\endcsname}%
  }
  {\DTLloaddb{specdb}{\specialityfilename}}
  {}%
  \ifcsname @specialityedu@name\@modifier\endcsname
  \else
    \DTLforeach*
    {specdb}
    {\Code=Code,\Name=Name}
    {%
      \DTLifstringeq{\Code}{\csname @specialityedu@code\@modifier\endcsname}
      {%
        \expandafter\edef\csname @specialityedu@name\@modifier\endcsname{\Name}%
        \dtlbreak
      }
      {}%
    }%
  \fi
  \ifcsname @specialityedu@fieldcode\@modifier\endcsname
  \else
    % \expandafter\def\csname @specialityedu@fieldcode\@modifier\endcsname
    %   {\substr{#2}{1}{2}}%      \DTLforeach*
    \expandafter\def\csname @specialityedu@fieldcode\@modifier\endcsname
      {\@gobble@third@digit#2\@nil}%   :   
  \fi
  \ifcsname @specialityedu@fieldname\@modifier\endcsname
  \else
    \DTLforeach*
    {specdb}
    {\Code=Code,\Name=Name}
    {%
      \DTLifstringeq{\Code}{\csname @specialityedu@fieldcode\@modifier\endcsname}
      {%
        \expandafter\edef\csname @specialityedu@fieldname\@modifier\endcsname{\Name}%
        \dtlbreak
      }
      {}%
    }%
  \fi
  \DTLifdbexists{specdb}{\DTLcleardb{specdb}\DTLdeletedb{specdb}}{}%
}
\def\@gobble@third@digit#1#2#3\@nil{#1#2}
\WithSuffix\def\specialityedu(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \def\specialityfilename{specedu20170201n53.#1.csv}%
  \specialityedu
}
% ,   
\define@key{institution}{altname}{%
  \expandafter\def\csname @institution@altname\@modifier\endcsname{#1}%
}
% ϳ  ,   
%       
% ( ,      ),
%    linux.org.ua:
% https://linux.org.ua/index.php?topic=689.msg90111#msg90111
\define@key{institution}{department}{%
  \expandafter\def\csname @institution@department\@modifier\endcsname{#1}%
}
%      ,
%     ,  ,   .
\define@key{institution}{preposition}{%
  \expandafter\def\csname @institution@preposition\@modifier\endcsname{#1}%
}
\renewcommand{\institution}[3][]{%
  \@split@institution#2,,\@nil
  \setkeys{institution}{#1}%
  \expandafter\def\csname @towni\@modifier\endcsname{#3}%
}
\def\@split@institution#1,#2,#3\@nil{%
  \expandafter\def\csname @institution\@modifier\endcsname{#1}%
  \ifx\relax#2\relax
  \else
    \expandafter\def\csname @institution@office\@modifier\endcsname{\ignorespaces#2}%
  \fi
}
\WithSuffix\def\institution(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \institution
}
% ,   
%%  
%% \council[
%%   institution={, },
%%   altname=  ,
%%   address={ },
%%   town=
%% ]{ }
\define@key{council}{institution}{%
  \@split@council@institution#1,,\@nil
}
\def\@split@council@institution#1,#2,#3\@nil{%
  \expandafter\def\csname @council@institution\@modifier\endcsname{#1}%
  \ifx\relax#2\relax
  \else
    \expandafter\def\csname @council@institution@office\@modifier\endcsname{\ignorespaces#2}%
  \fi
}
\define@key{council}{altname}{%
  \expandafter\def\csname @council@institution@altname\@modifier\endcsname{#1}%
}
%+TODO:      address
% TODO:       ,     .
\define@key{council}{address}{%
  \expandafter\def\csname @council@address\@modifier\endcsname{#1}%
}
\define@key{council}{town}{%
  \expandafter\def\csname @council@town\@modifier\endcsname{#1}%
}
\renewcommand{\council}[2][]{%
  \expandafter\def\csname @council@code\@modifier\endcsname{#2}%
  \setkeys{council}{#1}%
}
\WithSuffix\def\council(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \council
}
%  \secretary      councilsec 
%          :
%    , /,  .
%      
% ( ,      ),
%    linux.org.ua:
% https://linux.org.ua/index.php?topic=689.msg68367#msg68367
% https://linux.org.ua/index.php?topic=689.msg200196#msg200196
\define@key{secretary}{degree}{%
  \expandafter\def\csname @secretary@degree\@modifier\endcsname{#1}%
}
%  ,
%     councilsec, . .
% \define@boolkey{secretary}{councilcode}[false]{}
%  ,
% .  \facsimilesig.
% \define@key{secretary}{signature}{%
%   \expandafter\def\csname @secretary@signature\@modifier\endcsname{#1}%
% }
\renewcommand{\secretary}[2][]{%
  \setkeys{secretary}{#1}%
  \expandafter\def\csname @secretary\@modifier\endcsname{#2}%
}
\WithSuffix\def\secretary(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \secretary
}
\AtBeginDocument{%
% TODO: \secretaryname  \secretarytext?  ?
%  \secretaryname   㳺   
% \chaptername, \abstractname .
%   , ,   ,
%      '   ,
%    ,     ,
% '        .
\addto\captionsenglish{%
% TODO:       .
  \def\secretaryname{%
    Academic secretary\\
    of special academic council%
  }%
}
\addto\captionsukrainian{%
  \def\secretaryname{%
    \CYRU\cyrch\cyre\cyrn\cyri\cyrishrt\
    \cyrs\cyre\cyrk\cyrr\cyre\cyrt\cyra\cyrr\\
    \cyrs\cyrp\cyre\cyrc\cyrii\cyra\cyrl\cyrii\cyrz\cyro\cyrv\cyra\cyrn\cyro\cyryi\
    \cyrv\cyrch\cyre\cyrn\cyro\cyryi\
    \cyrr\cyra\cyrd\cyri
  }%
}%
}
% TODO:     \AtBeginDocument
%   \secretaryname  \captions<language>,
%       (   babel),
%    ,
%         ,
%  ,   \captions<language>,   .
%    ,    .
%       \AtBeginDocument
%  \secretaryname    .
%    ,          ,
%      .
%  ,   .
% , ,      
%       (,    ).
% ,    babel  ?
%
%  
% \facsimilesig#1(#2)[#3]#4 -> \put(#2){\includegraphics[#3]{#4}}
% #1   = author  secretary
% (#2) = (  x,   y)
% [#3] = [  \includegraphics]
% #4   = '    
%        
%    
% ( ,      ),
%    linux.org.ua:
% https://linux.org.ua/index.php?topic=689.msg68193#msg68193
% https://linux.org.ua/index.php?topic=689.msg200078#msg200078
% https://linux.org.ua/index.php?topic=689.msg202533#msg202533
% NOTE:      \signature,
%        letter ( ,   ),
%  , ,      :
% https://en.wikibooks.org/wiki/LaTeX/Letters
%      ,    (facsimile signature),
%    ,        .
%   facsimile        ,
%  ,  ,    :
% https://en.wikipedia.org/wiki/Facsimile
%      '     :
% https://www.ctan.org/pkg/facsimile
%    \facsimilesig,
%     ,
%   
%          .
\def\facsimilesig#1(#2)[#3]#4{%
  \expandafter\def\csname #1@signature\endcsname{%
    \put(#2){\includegraphics[#3]{#4}}%
  }%
}
%%  
%% \library{}{}
%  \library   ,
%        ,
%    -   .
%     
%     \library.
%   ,      .
%    2020-12-29  ipvm:
% https://linux.org.ua/index.php?topic=689.msg203518#msg203518
\renewcommand{\library}[2]{%
  \ifx\relax#1\relax
  \else
    \expandafter\def\csname @library@institution\@modifier\endcsname{#1}%
  \fi
  \ifx\relax#2\relax
  \else
    \expandafter\def\csname @library@address\@modifier\endcsname{#2}%
  \fi
}
\WithSuffix\def\library(#1){%
  \def\@modifier{@\csname#1language\endcsname}%
  \library
}
%         .
%    ,   .
% (  vakaref.cls  )
\renewenvironment{listofpersons}[1]
  {\list{#1\hfil}{\topsep0pt\parsep0pt\itemsep.5\parskip
   \ifcsname @supervisors@\languagename\endcsname
     \settowidth\@tempdima{#1}%
     \setlength\labelwidth{\@tempdima}%
   \else
     \settowidth\@tempdima{\csname @supervisors@caption@\languagename\endcsname}
     \settowidth\@tempdimb{\@opponents@caption}
     \ifdim\@tempdima>\@tempdimb
       \setlength\labelwidth{\@tempdima}%
     \else
       \setlength\labelwidth{\@tempdimb}%
     \fi
   \fi
   \setlength\leftmargin{\labelwidth}%
   \addtolength\leftmargin{\labelsep}%
   \def\makelabel##1{##1}%
   \def\makephantomlabel##1{\phantom{##1}}}%
   \rightskip\@flushglue% !   ,      
                        % ?   Underfull \hbox
  }
  {\endlist}
%  
\renewcommand{\maketitle}{%
    \begin{titlepage}%
    % \@ifundefined{@council@institutiont}
    %   {\let\@council@institutiont\@council@institution}{\relax}%
    % \@ifundefined{@council@institutiont@office}
    %   {\let\@council@institutiont@office\relax}{\relax}%
    \begin{center}%
    \@makecover
    \end{center}%
    \newpage
    \parindent=0pt\relax
    \parskip=10pt plus 10pt minus 10pt
    \@makereverse
    \end{titlepage}%
}
%         
%    
\def\set@institutions@desc{%
  {\scshape
   \ifcsname @council@institution@office@\languagename\endcsname
     \csname @council@institution@office@\languagename\endcsname\par
   \fi
   \csname @council@institution@\languagename\endcsname\par}
}
\def\set@institutions@asc{%
  {\scshape
   \csname @council@institution@\languagename\endcsname\par
   \ifcsname @council@institution@office@\languagename\endcsname
     \csname @council@institution@office@\languagename\endcsname\par
   \fi}
}
% REVIEW:   
% \@institution@office@ukrainian  \@council@institutiont@office@ukrainian,
%    .
% ,         .
%    ,       ,
%     -- .
\def\set@institutions@ascd{%
  {\scshape
   \csname @council@institution@\languagename\endcsname\par
   \ifcsname @council@institution@office@\languagename\endcsname
     \iflanguage{ukrainian}%
       {\transformsentence{G}{\@council@institution@office@ukrainian} }%
       {\csname @council@institution@office@\languagename\endcsname}%
     \par
   \fi}
}
%       
%    
% (     )
%    2019/10/01   ,
%        
%         ,
%     c     
%  ...  ( )
%           :
%   .
%         ,
%      ,
%    : \specialitysci  \specialityedu.
\def\set@speciality@cd{%
  \csname @specialitysci@code@\languagename\endcsname\
  \cdash---
  \csname @specialitysci@name@\languagename\endcsname
  \ifcsname @specialityedu@code@\languagename\endcsname
    \par
    \csname @specialityedu@code@\languagename\endcsname\
    \cdash---
    \csname @specialityedu@name@\languagename\endcsname
  \fi
}
\def\set@abstract@speciality@cd{%
  \csname @specialitysci@code@\languagename\endcsname\
  \cdash---
  \csname @specialitysci@name@\languagename\endcsname
  \ifcsname @specialityedu@code@\languagename\endcsname
    \ (\csname @specialityedu@code@\languagename\endcsname\
    \cdash---
    \csname @specialityedu@name@\languagename\endcsname)%
  \fi
}
\def\set@speciality@phdartdscd{%
  \csname @specialityedu@code@\languagename\endcsname\
  \cdash---
  \csname @specialityedu@name@\languagename\endcsname\par
  \csname @specialityedu@fieldname@\languagename\endcsname
}
\def\set@abstract@speciality@phdartdscd{%
  \csname @specialityedu@code@\languagename\endcsname\
  \cdash---
  \csname @specialityedu@name@\languagename\endcsname
}
%  mon2017dev.karazin.clo  degreefield   ,    .
%    CSV-:     ,
%       .
%   ,    , :
% https://uk.wikipedia.org/wiki/_#_
% https://uk.wikipedia.org/wiki/_#____
\def\degreefield@tf@ukrainian#1{%
  \IfEndWith{#1}{\cyrii}{%
    \StrGobbleRight{#1}{1}\cyri\cyrh\ \cyrn\cyra\cyru\cyrk
    % \case[adjective]{G}{#1} %   
  }{%
    \IfStrEqCase{#1}{%
      {\cyra\cyrr\cyrh\cyrii\cyrt\cyre\cyrk\cyrt\cyru\cyrr\cyra}% 
      {\StrGobbleRight{#1}{1}\cyri}% \case{G}{#1}   
      {\cyrk\cyru\cyrl\cyrsftsn\cyrt\cyru\cyrr\cyro\cyrl\cyro\cyrg\cyrii\cyrya}% 
      {\StrGobbleRight{#1}{1}\cyryi}%
      {\cyrm\cyri\cyrs\cyrt\cyre\cyrc\cyrt\cyrv\cyro\cyrz\cyrn\cyra\cyrv\cyrs\cyrt\cyrv\cyro}% 
      {\StrGobbleRight{#1}{1}\cyra}%
      {\cyrd\cyre\cyrr\cyrzh\cyra\cyrv\cyrn\cyre\space
        \cyru\cyrp\cyrr\cyra\cyrv\cyrl\cyrii\cyrn\cyrn\cyrya}%  
      {\cyrn\cyra\cyru\cyrk\ \cyrz\
        \cyrd\cyre\cyrr\cyrzh\cyra\cyrv\cyrn\cyro\cyrg\cyro\
        \cyru\cyrp\cyrr\cyra\cyrv\cyrl\cyrii\cyrn\cyrn\cyrya}%
      {\cyrf\cyrii\cyrz\cyri\cyrch\cyrn\cyre\space
        \cyrv\cyri\cyrh\cyro\cyrv\cyra\cyrn\cyrn\cyrya\space
        \cyrii\space
        \cyrs\cyrp\cyro\cyrr\cyrt}%    
      {\cyrn\cyra\cyru\cyrk\ \cyrz\
        \cyrf\cyrii\cyrz\cyri\cyrch\cyrn\cyro\cyrg\cyro\
        \cyrv\cyri\cyrh\cyro\cyrv\cyra\cyrn\cyrn\cyrya\
        \cyrii\
        \cyrs\cyrp\cyro\cyrr\cyrt\cyru}%
      {\cyrs\cyro\cyrc\cyrii\cyra\cyrl\cyrsftsn\cyrn\cyrii\space
        \cyrk\cyro\cyrm\cyru\cyrn\cyrii\cyrk\cyra\cyrc\cyrii\cyryi}%  
      {\cyrn\cyra\cyru\cyrk\ \cyrii\cyrz\
        \cyrs\cyro\cyrc\cyrii\cyra\cyrl\cyrsftsn\cyrn\cyri\cyrh\
        \cyrk\cyro\cyrm\cyru\cyrn\cyrii\cyrk\cyra\cyrc\cyrii\cyrishrt}%
    }%
    [#1]%
  }%
}
\def\degreefield@tf@russian#1{%
  \IfEndWith{#1}{\cyre}{%
    \StrGobbleRight{#1}{1}\cyrh\ \cyrn\cyra\cyru\cyrk
    % \case[adjective]{G}{#1} %   
  }{%
    \IfStrEqCase{#1}{%
      {\cyra\cyrr\cyrh\cyri\cyrt\cyre\cyrk\cyrt\cyru\cyrr\cyra}% 
      {\StrGobbleRight{#1}{1}\cyrery}% \case{G}{#1}   
      {\cyrk\cyru\cyrl\cyrsftsn\cyrt\cyru\cyrr\cyro\cyrl\cyro\cyrg\cyri\cyrya}% 
      {\StrGobbleRight{#1}{1}\cyri}%
      {\cyri\cyrs\cyrk\cyru\cyrs\cyrs\cyrt\cyrv\cyro\cyrv\cyre\cyrd\cyre\cyrn\cyri\cyre}% % FIXME:  ,    ,  ,    
      {\StrGobbleRight{#1}{1}\cyrya}%
      {\cyrg\cyro\cyrs\cyru\cyrd\cyra\cyrr\cyrs\cyrt\cyrv\cyre\cyrn\cyrn\cyro\cyre\space
        \cyru\cyrp\cyrr\cyra\cyrv\cyrl\cyre\cyrn\cyri\cyre}%  % FIXME:  ,    ,  ,    
      {\cyrn\cyra\cyru\cyrk\ \cyrp\cyro\
        \cyrg\cyro\cyrs\cyru\cyrd\cyra\cyrr\cyrs\cyrt\cyrv\cyre\cyrn\cyrn\cyro\cyrm\cyru\
        \cyru\cyrp\cyrr\cyra\cyrv\cyrl\cyre\cyrn\cyri\cyryu}%
      {\cyrf\cyri\cyrz\cyri\cyrch\cyre\cyrs\cyrk\cyro\cyre\space
        \cyrv\cyro\cyrs\cyrp\cyri\cyrt\cyra\cyrn\cyri\cyre\space
        \cyri\space
        \cyrs\cyrp\cyro\cyrr\cyrt}%    
      {\cyrn\cyra\cyru\cyrk\ \cyrp\cyro\
        \cyrf\cyri\cyrz\cyri\cyrch\cyre\cyrs\cyrk\cyro\cyrm\cyru\
        \cyrv\cyro\cyrs\cyrp\cyri\cyrt\cyra\cyrn\cyri\cyryu\
        \cyri\
        \cyrs\cyrp\cyro\cyrr\cyrt\cyru}%
      {\cyrs\cyro\cyrc\cyri\cyra\cyrl\cyrsftsn\cyrn\cyrery\cyre\space
        \cyrk\cyro\cyrm\cyrm\cyru\cyrn\cyri\cyrk\cyra\cyrc\cyri\cyri}%  
      {\cyrn\cyra\cyru\cyrk\ \cyrp\cyro\
        \cyrs\cyro\cyrc\cyri\cyra\cyrl\cyrsftsn\cyrn\cyrery\cyrm\
        \cyrk\cyro\cyrm\cyrm\cyru\cyrn\cyri\cyrk\cyra\cyrc\cyri\cyrya\cyrm}%
    }%
    [#1]%
  }%
}
% TODO:       ( ).
%          .
%      (  ).
\def\degreefield@tf@english#1{#1 sciences}
\def\set@degree@c{%
  \degreename\
  \csname degreefield@tf@\languagename\endcsname{\csname @specialitysci@degreefield@\languagename\endcsname}%
  \ifcsname @specialityedu@code@\languagename\endcsname
    \ (\degreephdname)%
  \fi
}
%   ,       0.04  mon2017dev,
%     \set@degree    c  d.
%  \degreename\  \csname   ,
%       
%          d.
%    2020/07/28   .
\def\set@degree@d{%
  \degreename\
  \csname degreefield@tf@\languagename\endcsname{\csname @specialitysci@degreefield@\languagename\endcsname}%
}
\def\set@degree@phdartdscd{%
  \degreename
}
\def\@makecover{%
  \set@institutions
  \vspace{\stretch{3}}%
  {\bfseries\expandafter\expandafter\expandafter\emphsurname\csname @author@\languagename\endcsname
  \ifcsname author@signature\endcsname
    \begin{picture}(0,0)
      \csname author@signature\endcsname
    \end{picture}
  \fi
  \par}%
  \vspace{\stretch{2}}%
  {\raggedleft \CYRU\CYRD\CYRK\ \@udc \par}%
  \vspace{\stretch{1}}%
  {\large\bfseries\scshape \csname @title@\languagename\endcsname \par}%
  \vspace{\stretch{2}}%
  \set@speciality\par
  \vspace{\stretch{3}}%
  \CYRA\cyrv\cyrt\cyro\cyrr\cyre\cyrf\cyre\cyrr\cyra\cyrt\linebreak[1]%
  \cyrd\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyryi\
    \cyrn\cyra\ \cyrz\cyrd\cyro\cyrb\cyru\cyrt\cyrt\cyrya\
    \cyrn\cyra\cyru\cyrk\cyro\cyrv\cyro\cyrg\cyro\
    \cyrs\cyrt\cyru\cyrp\cyre\cyrn\cyrya\linebreak[1]%
    \set@degree\par
  \vspace{\stretch{3}}%
  \ifcsname @council@town@\languagename\endcsname
    \csname @council@town@\languagename\endcsname
  \else
    \csname @towni@\languagename\endcsname
  \fi
  \ --- \@year}
\def\@makereverse{%
  \CYRD\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyrie\cyryu\
    \cyrie\ \@thesistype.\par
  \CYRR\cyro\cyrb\cyro\cyrt\cyra\
    \cyrv\cyri\cyrk\cyro\cyrn\cyra\cyrn\cyra\
    \ifcsname @institution@preposition@\languagename\endcsname
      \csname @institution@preposition@\languagename\endcsname
    \else
      \cyrv
    \fi
    \
% TODO:    .
% ,       ,
%    @institution@altname ?
    \ifcsname @institution@department@\languagename\endcsname
      \iflanguage{ukrainian}%
        {\transformsentence{L}{\@institution@department@ukrainian} }%
        {\csname @institution@department@\languagename\endcsname}%
      \
      \ifcsname @institution@altname@\languagename\endcsname
        \iflanguage{ukrainian}%
          {\transformsentence{G}{\@institution@altname@ukrainian} }%
          {of \csname @institution@altname@\languagename\endcsname}%
      \else
        \iflanguage{ukrainian}%
          {\transformsentence{G}{\@institution@ukrainian} }%
          {of \csname @institution@\languagename\endcsname}%
        \ifcsname @institution@office@\languagename\endcsname
          \
          \iflanguage{ukrainian}%
            {\transformsentence{G}{\@institution@office@ukrainian} }%
            {of \csname @institution@office@\languagename\endcsname}%
        \fi
      \fi
    \else
      \ifcsname @institution@altname@\languagename\endcsname
        \iflanguage{ukrainian}%
          {\transformsentence{L}{\@institution@altname@ukrainian} }%
          {\csname @institution@altname@\languagename\endcsname}%
      \else
        \iflanguage{ukrainian}%
          {\transformsentence{L}{\@institution@ukrainian} }%
          {\csname @institution@\languagename\endcsname}%
        \ifcsname @institution@office@\languagename\endcsname
          \
          \iflanguage{ukrainian}%
            {\transformsentence{G}{\@institution@office@ukrainian} }%
            {of \csname @institution@office@\languagename\endcsname}%
        \fi
      \fi
    \fi
    .\par
  {\let\\\@format@person
   \ifcsname @supervisors@\languagename\endcsname
     \begin{listofpersons}{\@supervisors@caption}
       \csname @supervisors@\languagename\endcsname\relax
     \end{listofpersons}
   \fi
   \begin{listofpersons}{\@opponents@caption}
     \@opponents\relax
   \end{listofpersons}}%
  \@ifundefined{@linstitution}{}{%
    \CYRP\cyrr\cyro\cyrv\cyrii\cyrd\cyrn\cyra\ \cyru\cyrs\cyrt\cyra\cyrn\cyro\cyrv\cyra:\
    \@linstitution, \@linstitution@town.\par}
  \vfill%\vspace{30pt plus 30pt minus 30pt}%
  \CYRZ\cyra\cyrh\cyri\cyrs\cyrt\
    \cyrv\cyrii\cyrd\cyrb\cyru\cyrd\cyre\cyrt\cyrsftsn\cyrs\cyrya\
    \@ifundefined{@defencedate}{\typedateholder}
      {\expandafter\typedate\@defencedate\@nil}%
    \ \cyro\
    \@ifundefined{@defencetime}{\typetimeholder}
      {\expandafter\typetime\@defencetime\@nil}%
\ \cyrn\cyra\ \cyrz\cyra\cyrs\cyrii\cyrd\cyra\cyrn\cyrn\cyrii\
    \cyrs\cyrp\cyre\cyrc\cyrii\cyra\cyrl\cyrii\cyrz\cyro\cyrv\cyra\cyrn\cyro\cyryi\
    \cyrv\cyrch\cyre\cyrn\cyro\cyryi\ \cyrr\cyra\cyrd\cyri\
    \csname @council@code@\languagename\endcsname\
    \ifcsname @council@institution@altname@\languagename\endcsname
      \iflanguage{ukrainian}%
        {\transformsentence{G}{\@council@institution@altname@ukrainian} }%
        {\csname @council@institution@altname@\languagename\endcsname}%
    \else
      \iflanguage{ukrainian}%
        {\transformsentence{G}{\@council@institution@ukrainian} }%
        {\csname @council@institution@\languagename\endcsname}%
      \ifcsname @council@institution@office@\languagename\endcsname
        \
        \iflanguage{ukrainian}%
          {\transformsentence{G}{\@council@institution@office@ukrainian} }%
          {of \csname @council@institution@office@\languagename\endcsname}%
      \fi
    \fi
    \ \cyrz\cyra\ \cyra\cyrd\cyrr\cyre\cyrs\cyro\cyryu:
    \csname @council@address@\languagename\endcsname.\par
  \vfil%\smallskip
  \CYRZ\ \cyrd\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyrie\cyryu\
    \cyrm\cyro\cyrzh\cyrn\cyra\
    \cyro\cyrz\cyrn\cyra\cyrishrt\cyro\cyrm\cyri\cyrt\cyri\cyrs\cyrsftsn\
    \cyru\
    \ifcsname @library@institution@\languagename\endcsname
      \iflanguage{ukrainian}%
        {\transformsentence{L}{\@library@institution@ukrainian} }%
        {\csname @library@institution@\languagename\endcsname}%
    \else
      \cyrb\cyrii\cyrb\cyrl\cyrii\cyro\cyrt\cyre\cyrc\cyrii\
      \ifcsname @council@institution@altname@\languagename\endcsname
        \iflanguage{ukrainian}%
          {\transformsentence{G}{\@council@institution@altname@ukrainian} }%
          {\csname @council@institution@altname@\languagename\endcsname}%
      \else
        \iflanguage{ukrainian}%
          {\transformsentence{G}{\@council@institution@ukrainian} \ \transformsentence{G}{\@council@institution@office@ukrainian} }%
          {\csname @council@institution@\languagename\endcsname\ of \csname @council@institution@office@\languagename\endcsname}%
      \fi
    \fi
    \ifcsname @library@address@\languagename\endcsname
      \ \cyrz\cyra\ \cyra\cyrd\cyrr\cyre\cyrs\cyro\cyryu:
      \csname @library@address@\languagename\endcsname
    \fi
    \@addpunct{.}\par
  \vfill%\vspace{10pt plus 10pt minus 10pt}%
  \CYRA\cyrv\cyrt\cyro\cyrr\cyre\cyrf\cyre\cyrr\cyra\cyrt\
    \cyrr\cyro\cyrz\cyrii\cyrs\cyrl\cyra\cyrn\cyri\cyrishrt\
    \@ifundefined{@postdate}{\typedateholder}
      {\expandafter\typedate\@postdate\@nil}\par
  \vfill%\vspace{20pt plus 20pt minus 20pt}%
  % \CYRU\cyrch\cyre\cyrn\cyri\cyrishrt\
  % \cyrs\cyre\cyrk\cyrr\cyre\cyrt\cyra\cyrr\newline
  % \cyrs\cyrp\cyre\cyrc\cyrii\cyra\cyrl\cyrii\cyrz\cyro\cyrv\cyra\cyrn\cyro\cyryi\
  % \cyrv\cyrch\cyre\cyrn\cyro\cyryi\ \cyrr\cyra\cyrd\cyri
  \secretaryname
%   councilcode     councilsec
  % \ifKV@secretary@councilcode
  %   \
  %   \csname @council@code@\languagename\endcsname
  % \fi
  \csname ifKV@mon2017dev-aref.cls@councilsec\endcsname
    \
    \csname @council@code@\languagename\endcsname
  \fi
  \ifcsname @secretary@degree@\languagename\endcsname
    \\
    \csname @secretary@degree@\languagename\endcsname
  \fi
  \hfill
  \ifcsname secretary@signature\endcsname
%  minipage  ,    .
%  \raisebox  ,    ' ,
%     ,    -- .
%       \secretary  , 
% 1)      ,
% 2)              .
    % \raisebox{-10pt}{%
    %   \begin{minipage}[b][0pt]{50pt}
    %     \expandafter\expandafter\expandafter\includegraphics\csname @secretary@signature@\languagename\endcsname
    %   \end{minipage}
    % }%
%          ,
%    ,   :
% https://tex.stackexchange.com/a/328858
    \begin{picture}(0,0)
      \csname secretary@signature\endcsname
    \end{picture}
  \fi
  \hfill
  %\placeholder{\cyrp\cyrii\cyrd\cyrp\cyri\cyrs}\quad
  \csname @secretary@\languagename\endcsname\par}
% Abstract    ,     
\define@cmdkey{abstract}{language}{}
\define@cmdkey{abstract}{chapter}[true]{}
\define@boolkey{abstract}{header}[true]{}
\renewenvironment{abstract}[1][]{%
  \def\cmdKV@abstract@chapter{false}%
  \KV@abstract@headertrue
  \setkeys{abstract}{#1}%
  \ifdefined\cmdKV@abstract@language
    \expandafter\selectlanguage\expandafter{\cmdKV@abstract@language}%
  \fi
  \ifdefined\cmdKV@abstract@chapter
    \def\@tempa{true}%
    \def\@tempb{false}%
    \ifx\cmdKV@abstract@chapter\@tempb
      \bigskip
    \else
      \ifx\cmdKV@abstract@chapter\@tempa
      \else
        \def\abstractname{\cmdKV@abstract@chapter}%
      \fi
      \part{\abstractname}%
    \fi
  \else
    \part{\abstractname}%
  \fi
  \@mkboth{\MakeUppercase\abstractname}{\MakeUppercase\abstractname}%
  \ifKV@abstract@header
    \@abstract
  \fi
}{%
}
\def\@abstract{%
  \emph{\csname shortauthor@@\languagename\endcsname}
  \csname @title@\languagename\endcsname.
  \cdash---
  \manuscriptname.
  \par
  \set@thesisdescription.
  \cdash---
  \ifcsname @council@institution@altname@\languagename\endcsname
    \csname @council@institution@altname@\languagename\endcsname
  \else
    \ifcsname @council@institution@\languagename\endcsname
      \ifcsname @council@institution@office@\languagename\endcsname
        \csname @council@institution@office@\languagename\endcsname,
      \fi
      \csname @council@institution@\languagename\endcsname
    \fi
  \fi
  ,
  \ifcsname @council@town@\languagename\endcsname
    \csname @council@town@\languagename\endcsname
  \else
    \csname @towni@\languagename\endcsname
  \fi,
  \@year.
  \par
  \smallskip
}
%       (   ,   )
\newcommand{\keywords}[1]{%
  \smallskip
  \emph{\keywordsname}:
  #1.
  \par
  % \bigskip
}
%        .
% TODO:   approval  ?
% https://en.wiktionary.org/wiki/approval
% https://en.wiktionary.org/wiki/approbation
% https://e2u.org.ua/s?w=%D0%B0%D0%BF%D1%80%D0%BE%D0%B1%D0%B0%D1%86%D1%96%D1%8F&dicts=all&highlight=on&filter_lines=on
%        .
%       .
%    '  .
%       .
% FIXME:  ,    .
\NewEnviron{approval}[1][\approvalname]{%
  \paragraph{#1}%
  \BODY
}
\newcommand{\repeatapproval}{%
}
\def\approvalname{%
  %   
  {\cyr\CYRA\cyrp\cyrr\cyro\cyrb\cyra\cyrc\cyrii\cyrya\
    \cyrm\cyra\cyrt\cyre\cyrr\cyrii\cyra\cyrl\cyrii\cyrv\
    \cyrd\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyryi}%
}%
% ֳ      .
%    ,     ,    -- .
%   --    .
\newcommand{\participation}[1]{\unskip}
%      ,   .
%  .
\newcommand{\repeatauthorpublications}{%
}
%   bibset  vakthesis (   ).
\newcounter{needbibset}
\setcounter{needbibset}{1}
\newcounter{currbibset}
\newenvironment{bibset}[2][]
  {\stepcounter{currbibset}%
   \def\@temp{#1}%
   \ifx\@temp\@empty
     \def\@bibmark{\relax}%FIXME: \def\@bibmark{}  
   \else
     \def\@bibmark{\textsuperscript{#1}}%
   \fi
   \let\@sav@lbibitem\@lbibitem
   \def\@lbibitem[##1]##2{\@sav@lbibitem[##1\@bibmark]{##2}}%
   \@ifundefined{hyper@warn}
%%     hyperref
     {\def\@bibitem##1{\item\if@filesw \immediate\write\@auxout
        {\string\bibcite{##1}{\the\value{\@listctr}\expandafter\string\@bibmark}}%
        \fi\ignorespaces}}
%%    hyperref
     {\def\@bibitem##1{%
      \@skiphyperreftrue\H@item\@skiphyperreffalse
      \hyper@anchorstart{cite.##1}\relax\hyper@anchorend
      \if@filesw {\let\protect\noexpand
      \immediate\write\@auxout{%
        \string\bibcite{##1}{\the\value{\@listctr}\expandafter\string\@bibmark}}}%
      \fi
      \ignorespaces}}%
   \def\bibname{#2}%
   \let\bibliography\@thisbibliography
   \let\bibliographystyle\@thisbibliographystyle}
  {\ifnum\thecurrbibset=\theneedbibset
     \ifnum\theneedbibset=1
       \immediate\write\@auxout{\string\setcounter{needbibset}{2}}%
     \else
       \immediate\write\@auxout{\string\setcounter{needbibset}{1}}%
     \fi
   \fi}
\def\@thisbibliography#1{%
  \if@filesw
    \ifnum\thecurrbibset=\theneedbibset
      \immediate\write\@auxout{\string\bibdata{#1}}%
    \else
      \immediate\write\@auxout{\@percentchar\string\bibdata{#1}}%
    \fi
  \fi
  \@input@{\jobname\thecurrbibset.bbl}}
\def\@thisbibliographystyle#1{%
  \ifx\@begindocumenthook\@undefined\else
    \expandafter\AtBeginDocument
  \fi
    {\if@filesw
       \ifnum\thecurrbibset=\theneedbibset
         \immediate\write\@auxout{\string\bibstyle{#1}}%
       \else
         \immediate\write\@auxout{\@percentchar\string\bibstyle{#1}}%
       \fi
     \fi}%
%%   1.
  \ifthenelse
  {\equal{#1}{plain}\or\equal{#1}{unsrt}\or\equal{#1}{abbrv}\or
   \equal{#1}{amsplain}\or
   \equal{#1}{gost71s}\or\equal{#1}{gost71u}\or\equal{#1}{gost780s}\or\equal{#1}{gost780u}\or
   \equal{#1}{my_gost71s}}
  {\def\@biblabel##1{##1.}}
  {\def\@biblabel##1{[##1]}}}
%   (,   )
% TODO:     .
%    ,    .
%   ,     -- ukrainian,
%     .
%       
% ( english --   ).
\AtBeginDocument{%
\addto\captionsenglish{%
  \def\manuscriptname{%
    % FIXME: Qualification  Qualifying?
    Qualification scientific work in the form of manuscript%
  }%
  \def\set@thesisdescription{%
    Thesis for \set@degree\ degree
    in speciality \set@abstract@speciality
  }%
  \def\keywordsname{Key words}%
}
\addto\captionsrussian{%
  \def\manuscriptname{%
    %      
    \CYRK\cyrv\cyra\cyrl\cyri\cyrf\cyri\cyrk\cyra\cyrc\cyri\cyro\cyrn\cyrn\cyrery\cyrishrt\
    \cyrn\cyra\cyru\cyrch\cyrn\cyrery\cyrishrt\
    \cyrt\cyrr\cyru\cyrd\
    \cyrn\cyra\
    \cyrp\cyrr\cyra\cyrv\cyra\cyrh\
    \cyrr\cyru\cyrk\cyro\cyrp\cyri\cyrs\cyri
  }%
  \def\set@thesisdescription{%
    %     
    %    ( )
    \CYRD\cyri\cyrs\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyri\cyrya\
    \cyrn\cyra\
    \cyrs\cyro\cyri\cyrs\cyrk\cyra\cyrn\cyri\cyre\
    \cyrn\cyra\cyru\cyrch\cyrn\cyro\cyrishrt\
    \cyrs\cyrt\cyre\cyrp\cyre\cyrn\cyri\
    \set@degree\
    \cyrp\cyro\
    \cyrs\cyrp\cyre\cyrc\cyri\cyra\cyrl\cyrsftsn\cyrn\cyro\cyrs\cyrt\cyri\
    \set@abstract@speciality
  }%
  \def\keywordsname{\CYRK\cyrl\cyryu\cyrch\cyre\cyrv\cyrery\cyre\ \cyrs\cyrl\cyro\cyrv\cyra}%
}
\addto\captionsukrainian{%
  \def\manuscriptname{%
    %      
    \CYRK\cyrv\cyra\cyrl\cyrii\cyrf\cyrii\cyrk\cyra\cyrc\cyrii\cyrishrt\cyrn\cyra\
    \cyrn\cyra\cyru\cyrk\cyro\cyrv\cyra\
    \cyrp\cyrr\cyra\cyrc\cyrya\
    \cyrn\cyra\
    \cyrp\cyrr\cyra\cyrv\cyra\cyrh\
    \cyrr\cyru\cyrk\cyro\cyrp\cyri\cyrs\cyru
  }%
  \def\set@thesisdescription{%
    %     
    %    ( )
    \CYRD\cyri\cyrs\cyre\cyrr\cyrt\cyra\cyrc\cyrii\cyrya\
    \cyrn\cyra\
    \cyrz\cyrd\cyro\cyrb\cyru\cyrt\cyrt\cyrya\
    \cyrn\cyra\cyru\cyrk\cyro\cyrv\cyro\cyrg\cyro\
    \cyrs\cyrt\cyru\cyrp\cyre\cyrn\cyrya\
    \set@degree\
    \cyrz\cyra\
    \cyrs\cyrp\cyre\cyrc\cyrii\cyra\cyrl\cyrsftsn\cyrn\cyrii\cyrs\cyrt\cyryu\
    \set@abstract@speciality
  }%
  \def\keywordsname{\CYRK\cyrl\cyryu\cyrch\cyro\cyrv\cyrii\ \cyrs\cyrl\cyro\cyrv\cyra}%
}
}
%
%   babel-ukrainian
%
%   (2018/05/17)    (2019/08/01)  
%  ,    ( \cdash---)   .
%      \makeabstract
% (   0.02  mon2017dev  )
%      :
%   command \cyrdash unavailable in encoding OT1.
%  \cyrdash "---   ,   \cdash.
%      :
\ProvideTextCommandDefault{\cyrdash}{\hbox to.8em{--\hss--}}
%    ,
%   babel-ukrainian  1.4b  2017/08/10
%    .
%    , 
%  \cyrdash        T2A,
%     .
% ,     "--- ,
%  -     \cyrdash  
% (.  babel-ukrainian  1.4b  , ~6.4.2, .~10).
%  ,     
%   ,       babel-ukrainian
% ( 1.1l  2008/03/21),
%  ,     '  .
%    ,  ' ,    .
%     ,       .
%  ,  '  ,
%      \cyrdash.
%
%   vakthesis
%
%    2018/04/15   
% (https://linux.org.ua/index.php?topic=689.msg201933#msg201933),
%    ( enumerate)  
%      \@asbuk.
%    \@Asbuk.
%   vakthesis    \@Asbuk  \@asbuk.
%      babel.
%   babel-ukrainian,    1.4  2017/06/10,
%     .
%    \@Alph  \@alph    .
%  .
\def\@Asbuk{\@Alph}
\def\@asbuk{\@alph}
%       babel-ukrainian,
%     \@Asbuk  \@asbuk,
%    ,  \@Alph  \@alph .
%     babel-ukrainian,
%    \@Asbuk  \@asbuk,
%  babel-ukrainian    ,
%   ,   .
%     \providecommand,
%      (.  BUGS,   2018/04/15),
%     \@Asbuk  \@asbuk  -  .
%
%  casus
%
\AtBeginDocument{\usepackage{casus2017dev}}
\endinput
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Local Variables:
% mode: latex
% coding: windows-1251-dos
% End:
